/* Ce programme permet la commande d'un servomoteur de la carte arduino UNO
 *  en fonction du caractère recu par bluetooth.
 *  Le programme ci-dessous ne présente la solution que pour un seul doigt
 */

#include <SoftwareSerial.h>         //appel de la librairie de lecture du port serie
#include <Servo.h>                  //Appel de la librairie servo (déjà installé sur le logiciel)

Servo monServoMoteur;               //création d'un objet appelé monServoMoteur. A vous de choisir le nom

#define RxD         7               //RxD permettra la reception sur la broche 6 de la carte 
#define TxD         6               //TxD permettra la transmission sur la broche 7 de la carte 

int pos = 1;

SoftwareSerial blueToothSerial(RxD,TxD);  //permet de définir le port serie et les broches servant a la communication

void setup()
{
    Serial.begin(9600);                     //vitesse de communication
    pinMode(RxD, INPUT);                    //configuration de RxD donc broche 6 en entree- recoit les informations
    pinMode(TxD, OUTPUT);                   //configuration de TxD donc de la broche 7 en sortie- transmet les informations
    monServoMoteur.attach(9, 1000, 2000);   // (numéro de broche, temps pour 0°en microseconde, temps pour 180°en microseconde)
    
    
    setupBlueToothConnection();             //lancement de la fonction setBlueToothConnection()--- voir en bas du programme le detail de cette fonction
}

void loop()
{
    char recvChar;                          //definition d une variable de type caractere (char) du nom de recvChar
    
    while(1)                                //tant que la connection bluetooth est etablie
    {
        if(blueToothSerial.available())           //permet de tester si des données sont disponible dans le buffer du port série
        {
            recvChar = blueToothSerial.read();    //permet de lire les données du port série, un octet à la fois - mets le résultat dans la variable recvChar
            
            
//PARTIE A COMPLETER PAR LES ELEVES
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////            
            if(recvChar == '3')         //si le caractere recu est egal a 3
            {
                do 
                {
               monServoMoteur.write(pos);
               pos=pos+1;               //incrémentation d'un degré
               Serial.println(pos);     // affichage sur moniteur serie de la pos
               delay(10);               //delais entre 2 déplacements (controle de la vitesse)
                }
                while (recvChar == '2');  //rq:il manque la position extrême ||(pos=180)
            }
            else if(recvChar == '1')    //si le caractere recu est egal a 1
            {
                do 
                {
                  monServoMoteur.write(pos);
                  pos=pos-1;              //décrémentation d'un degré
                  Serial.println(pos);    // affichage sur moniteur serie de la pos
                  delay(10); 
                }
                while (recvChar == '2');  //rq:il manque la position extrême ||(pos=0)
            }
            else
            {}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////            
        }
    }
}


/***************************************************************************
 * nom de la fonction: setupBlueToothConnection
 * Description:  initialisation de la connection bluetooth
 * ATTENTION: NE PAS MODIFIER CETTE FONCTION SANS L ACCORD DU PROFESSEUR
***************************************************************************/
void setupBlueToothConnection()
{	
	
	blueToothSerial.begin(9600);  
	
	blueToothSerial.print("AT");
	delay(400); 

	blueToothSerial.print("AT+DEFAULT");             // remet les parametres PAR DEFAUT
	delay(2000); 
 
	  
	blueToothSerial.print("AT+NAMEesclave");    // METTRE LE NOM DE VOTRE EQUIPE APRES NAME ici equipe1
	delay(400);
	
    blueToothSerial.print("AT+PIN1234");             // NE PAS CHANGER permet de changer le code d authentification 
	delay(400);
	
	blueToothSerial.print("AT+AUTH1");             //demande de l authentification
    delay(400);    

    blueToothSerial.flush();  //permet de vider la mémoire du buffer

}
